# Negbin_plot.R
# Plot probabilities for the negative binomial distribution

# Load necessary libraries
library(ggplot2)

# Negative binomial parameters here
m <- 5
k <- 10

# Negative binomial distribution function
ymax <- 20
y <- 0:ymax
proby <- dnbinom(y,size=k,mu=m)

# Make data frame for ggplot2
nbdata <- as.data.frame(cbind(y,proby))

# Print data
nbdata

# Generate plot showing frequencies
ggplot(nbdata,aes(y,proby))+
geom_bar(stat="identity",width=0.05,fill="red")+
geom_point(color="red",size=3)+
ggtitle("Negative binomial distribution, m = 5, k = 5")
